<?php
/**
 * Page: site-editor-v2 (wp-admin integrated)
 * Auto-generated by build process.
 * Do not edit this file manually.
 *
 * This version integrates with the standard WordPress admin interface,
 * keeping the wp-admin sidebar and scripts/styles intact.
 *
 * @package gutenberg
 */

// Global storage for site-editor-v2 routes and menu items
global $gutenberg_site_editor_v2_wp_admin_routes, $gutenberg_site_editor_v2_wp_admin_menu_items;
$gutenberg_site_editor_v2_wp_admin_routes     = array();
$gutenberg_site_editor_v2_wp_admin_menu_items = array();

if ( ! function_exists( 'gutenberg_register_site_editor_v2_wp_admin_route' ) ) {
	/**
	 * Register a route for the site-editor-v2-wp-admin page.
	 *
	 * @param string      $path           Route path (e.g., '/types/$type/edit/$id').
	 * @param string|null $content_module Script module ID for content (stage/inspector).
	 * @param string|null $route_module   Script module ID for route lifecycle hooks.
	 */
	function gutenberg_register_site_editor_v2_wp_admin_route( $path, $content_module = null, $route_module = null ) {
		global $gutenberg_site_editor_v2_wp_admin_routes;

		$route = array( 'path' => $path );
		if ( ! empty( $content_module ) ) {
			$route['content_module'] = $content_module;
		}
		if ( ! empty( $route_module ) ) {
			$route['route_module'] = $route_module;
		}

		$gutenberg_site_editor_v2_wp_admin_routes[] = $route;
	}
}

if ( ! function_exists( 'gutenberg_register_site_editor_v2_wp_admin_menu_item' ) ) {
	/**
	 * Register a menu item for the site-editor-v2-wp-admin page.
	 * Note: Menu items are registered but not displayed in single-page mode.
	 *
	 * @param string $id        Menu item ID.
	 * @param string $label     Display label.
	 * @param string $to        Route path to navigate to.
	 * @param string $parent_id Optional. Parent menu item ID.
	 */
	function gutenberg_register_site_editor_v2_wp_admin_menu_item( $id, $label, $to, $parent_id = '' ) {
		global $gutenberg_site_editor_v2_wp_admin_menu_items;

		$menu_item = array(
			'id'    => $id,
			'label' => $label,
			'to'    => $to,
		);

		if ( ! empty( $parent_id ) ) {
			$menu_item['parent'] = $parent_id;
		}

		$gutenberg_site_editor_v2_wp_admin_menu_items[] = $menu_item;
	}
}

if ( ! function_exists( 'gutenberg_get_site_editor_v2_wp_admin_routes' ) ) {
	/**
	 * Get all registered routes for the site-editor-v2-wp-admin page.
	 *
	 * @return array Array of route objects.
	 */
	function gutenberg_get_site_editor_v2_wp_admin_routes() {
		global $gutenberg_site_editor_v2_wp_admin_routes;
		return $gutenberg_site_editor_v2_wp_admin_routes ?? array();
	}
}

if ( ! function_exists( 'gutenberg_get_site_editor_v2_wp_admin_menu_items' ) ) {
	/**
	 * Get all registered menu items for the site-editor-v2-wp-admin page.
	 *
	 * @return array Array of menu item objects.
	 */
	function gutenberg_get_site_editor_v2_wp_admin_menu_items() {
		global $gutenberg_site_editor_v2_wp_admin_menu_items;
		return $gutenberg_site_editor_v2_wp_admin_menu_items ?? array();
	}
}

if ( ! function_exists( 'gutenberg_site_editor_v2_wp_admin_preload_data' ) ) {
	/**
	 * Preload REST API data for the site-editor-v2-wp-admin page.
	 * Automatically called during page rendering.
	 */
	function gutenberg_site_editor_v2_wp_admin_preload_data() {
		// Define paths to preload - same for all pages
		$preload_paths = array(
			'/?_fields=description,gmt_offset,home,name,site_icon,site_icon_url,site_logo,timezone_string,url,page_for_posts,page_on_front,show_on_front',
			array( '/wp/v2/settings', 'OPTIONS' ),
		);

		// Use rest_preload_api_request to gather the preloaded data
		$preload_data = array_reduce(
			$preload_paths,
			'rest_preload_api_request',
			array()
		);

		// Register the preloading middleware with wp-api-fetch
		wp_add_inline_script(
			'wp-api-fetch',
			sprintf(
				'wp.apiFetch.use( wp.apiFetch.createPreloadingMiddleware( %s ) );',
				wp_json_encode( $preload_data )
			),
			'after'
		);
	}
}

if ( ! function_exists( 'gutenberg_site_editor_v2_wp_admin_enqueue_scripts' ) ) {
	/**
	 * Enqueue scripts and styles for the site-editor-v2-wp-admin page.
	 * Hooked to admin_enqueue_scripts.
	 *
	 * @param string $hook_suffix The current admin page.
	 */
	function gutenberg_site_editor_v2_wp_admin_enqueue_scripts( $hook_suffix ) {
		// Check all possible ways this page can be accessed:
		// 1. Menu page via admin.php?page=site-editor-v2-wp-admin (plugin)
		// 2. Direct file via site-editor-v2.php (Core) - screen ID will be 'site-editor-v2'
		$current_screen = get_current_screen();
		$is_our_page = (
			( isset( $_GET['page'] ) && 'site-editor-v2-wp-admin' === $_GET['page'] ) || // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			( $current_screen && 'site-editor-v2' === $current_screen->id )
		);

		if ( ! $is_our_page ) {
			return;
		}

		// Load build constants
		$build_constants = require __DIR__ . '/../../constants.php';

		// Fire init action for extensions to register routes and menu items
		do_action( 'site-editor-v2-wp-admin_init' );

		// Preload REST API data
		gutenberg_site_editor_v2_wp_admin_preload_data();

		// Get all registered routes
		$routes = gutenberg_get_site_editor_v2_wp_admin_routes();

		// Get boot module asset file for dependencies
		$asset_file = __DIR__ . '/../../modules/boot/index.min.asset.php';
		if ( file_exists( $asset_file ) ) {
			$asset = require $asset_file;

			// This script serves two purposes:
			// 1. It ensures all the globals that are made available to the modules are loaded.
			// 2. It initializes the boot module as an inline script.
			wp_register_script( 'site-editor-v2-wp-admin-prerequisites', '', $asset['dependencies'], $asset['version'], true );

			// Add inline script to initialize the app using initSinglePage (no menuItems)
			wp_add_inline_script(
				'site-editor-v2-wp-admin-prerequisites',
				sprintf(
					'import("@wordpress/boot").then(mod => mod.initSinglePage({mountId: "%s", routes: %s}));',
					'site-editor-v2-wp-admin-app',
					wp_json_encode( $routes, JSON_HEX_TAG | JSON_UNESCAPED_SLASHES )
				)
			);

			// Register prerequisites style by filtering script dependencies to find registered styles
			$style_dependencies = array_filter(
				$asset['dependencies'],
				function ( $handle ) {
					return wp_style_is( $handle, 'registered' );
				}
			);
			wp_register_style( 'site-editor-v2-wp-admin-prerequisites', false, $style_dependencies, $asset['version'] );

			// Build dependencies for site-editor-v2-wp-admin module
			$boot_dependencies = array(
				array(
					'import' => 'static',
					'id'     => '@wordpress/boot',
				),
			);

			// Add all registered routes as dependencies
			foreach ( $routes as $route ) {
				if ( isset( $route['route_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'static',
						'id'     => $route['route_module'],
					);
				}
				if ( isset( $route['content_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'dynamic',
						'id'     => $route['content_module'],
					);
				}
			}

			// Dummy script module to ensure dependencies are loaded
			wp_register_script_module(
				'site-editor-v2-wp-admin',
				$build_constants['build_url'] . 'pages/site-editor-v2/loader.js',
				$boot_dependencies
			);

			// Enqueue the boot scripts and styles
			wp_enqueue_script( 'site-editor-v2-wp-admin-prerequisites' );
			wp_enqueue_script_module( 'site-editor-v2-wp-admin' );
			wp_enqueue_style( 'site-editor-v2-wp-admin-prerequisites' );
		}
	}
}

if ( ! function_exists( 'gutenberg_site_editor_v2_wp_admin_render_page' ) ) {
	/**
	 * Render the site-editor-v2-wp-admin page.
	 * Call this function from add_menu_page or add_submenu_page.
	 * This renders within the normal WordPress admin interface.
	 */
	function gutenberg_site_editor_v2_wp_admin_render_page() {
		?>
		<style>
			/* Critical styles to prevent layout shifts - inlined for immediate application */

			/* Background colors */
			#wpwrap {
				background: var(--wpds-color-fg-content-neutral, #1e1e1e);
				overflow-y: auto;
			}
			body {
				background: #fff;
			}

			/* Reset wp-admin padding */
			#wpcontent {
				padding-left: 0;
			}
			#wpbody-content {
				padding-bottom: 0;
			}

			/* Hide legacy admin elements */
			#wpbody-content > div:not(.boot-layout-container):not(#screen-meta) {
				display: none;
			}
			#wpfooter {
				display: none;
			}

			/* Accessibility regions */
			.a11y-speak-region {
				left: -1px;
				top: -1px;
			}

			/* Admin menu indicators */
			ul#adminmenu a.wp-has-current-submenu::after,
			ul#adminmenu > li.current > a.current::after {
				border-right-color: #fff;
			}

			/* Media frame fix */
			.media-frame select.attachment-filters:last-of-type {
				width: auto;
				max-width: 100%;
			}

			/* Responsive overflow fix for #wpwrap */
			@media (min-width: 782px) {
				#wpwrap {
					overflow-y: initial;
				}
			}
		</style>
		<div id="site-editor-v2-wp-admin-app" class="boot-layout-container"></div>
		<?php
	}
}

// Hook the enqueue function to admin_enqueue_scripts
add_action( 'admin_enqueue_scripts', 'gutenberg_site_editor_v2_wp_admin_enqueue_scripts' );

