<?php
/**
 * Functions for Template Utility
 *
 * @package   PopupMaker
 * @copyright Copyright (c) 2024, Code Atlantic LLC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Get a templates part in $slug-$name.php fashion.
 *
 * Allows passing arguments that will be globally accessible in the templates.
 *
 * @param string $slug The slug of the template part.
 * @param string $name The name of the template part.
 * @param array  $args The arguments to pass to the template part.
 *
 * @return string
 */
function pum_get_template_part( $slug, $name = null, $args = null ) {
	return PUM_Utils_Template::get_part( $slug, $name, $args );
}


/**
 * Render a templates part in $slug-$name.php fashion.
 *
 * Allows passing arguments that will be globally accessible in the templates.
 *
 * @param string $slug The slug of the template part.
 * @param string $name The name of the template part.
 * @param array  $args The arguments to pass to the template part.
 */
function pum_template_part( $slug, $name = null, $args = [] ) {
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo pum_get_template_part( $slug, $name, $args );
}

/**
 * Gets the rendered contents of the specified templates file.
 *
 * @param string $template_name The name of the template.
 * @param array  $args The arguments to pass to the template.
 *
 * @return string
 */
function pum_get_template( $template_name, $args = [] ) {
	return PUM_Utils_Template::get( $template_name, $args );
}

/**
 * Get other templates (e.g. product attributes) passing attributes and including the file.
 *
 * @deprecated Likely a better way @see pum_template_part()
 *
 * @param string $template_name Template file name with extension: file-name.php The name of the template.
 * @param array  $args (default: array()) The arguments to pass to the template.
 */
function pum_load_template( $template_name, $args = [] ) {
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo pum_get_template( $template_name, $args );
}
