<?php // MyPlugin - Settings Page

// disable direct file access
if (!defined('ABSPATH')) {

    exit;
}


// display the plugin settings page
function myplugin_display_settings_page()
{

    // check if user is allowed access
    if (!current_user_can('manage_options')) {
        return;
    }

?>

    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">

            <?php

            // output security fields
            settings_fields('myplugin_options');

            // output setting sections
            do_settings_sections('myplugin');

            // submit button
            submit_button();

            ?>

        </form>
    </div>

<?php

}

function wdplugin_settings()
{

    // check if user is allowed access
    if (!current_user_can('manage_options')) {
        return;
    }

    include_once 'setup/wdplugin-settings-display-page.php';
    //include_once 'setup/wdplugin-add-plugin-styles.php';
}

function wdplugin_widget_list()
{
    // check if user is allowed access
    if (!current_user_can('manage_options')) {
        return;
    }

    include_once 'setup/wdplugin-widget-list.php';
}


add_filter('style-list', 'wdplugin_add_plugin_style');
